# LIRE MAIS NE RIEN MODIFIER DANS CE FICHIER
class Produit:
    """Contient uniquement les données métiers d'un produit."""
    def __init__(self, id_produit, nom, quantite, prix_unitaire):
        self.id_produit = id_produit
        self.nom = nom
        self.quantite = quantite
        self.prix_unitaire = prix_unitaire

    def __str__(self):
        return f"{self.id_produit} : {self.nom}, {self.quantite}, {self.prix_unitaire}"
    

class Stock:
    """
    Représente à la fois le conteneur et un nœud de l'arbre.
    Chaque instance de Stock contient un objet Produit dans 'valeur'.
    """
    def __init__(self, produit=None):
        self.valeur = produit  # Un objet de la classe Produit
        self.gauche = None     # Un objet de la classe Stock (ou None)
        self.droit = None      # Un objet de la classe Stock (ou None)

    def visualiser(self, prefixe="", est_fils_droit=False, est_racine=True):
        """Méthode d'affichage récursive."""
        if self.valeur is None:
            print("Stock vide")
            return

        if self.droit:
            nouveau_prefixe = prefixe + ("    " if est_fils_droit or est_racine else "│   ")
            self.droit.visualiser(nouveau_prefixe, True, False)

        symbole = ""
        if not est_racine:
            symbole = "┌── " if est_fils_droit else "└── "
        
        print(f"{prefixe}{symbole}{self.valeur.id_produit} ({self.valeur.nom})")

        if self.gauche:
            nouveau_prefixe = prefixe + ("    " if not est_fils_droit or est_racine else "│   ")
            self.gauche.visualiser(nouveau_prefixe, False, False)